%%
%% This is file `sid.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% sid.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2025 Gregory W. Cook <cook@ieee.org>
%% 
%% This file may be distributed and/or modified under the conditions of
%% the LaTeX Project Public License, either version 1.3 of this license
%% or (at your option) any later version.  The latest version of this
%% license is in:
%% 
%%    http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3c or later is part of all distributions of LaTeX version
%% 2008-05-04 or later.
%% 
\NeedsTeXFormat{LaTeX2e}[2023-11-01]
\ProvidesClass{sid}
    [2025-07-10 v0.03 .dtx sid file]




\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{sid}[2025-07-09 sid v0.03, Society for Information Display]

\usepackage{ifthen}
\newboolean{conf}
\setboolean{conf}{false}
\newboolean{symposium}
\setboolean{symposium}{false}
\newboolean{displayweek}
\setboolean{displayweek}{false}
\newboolean{idw}
\setboolean{idw}{false}
\newboolean{vdi}
\setboolean{vdi}{false}
\newboolean{journal}
\setboolean{journal}{false}
\DeclareOption{onecolumn}{\OptionNotUsed}
\DeclareOption{conf}{\setboolean{conf}{true}}
\DeclareOption{symposium}{\setboolean{symposium}{true}}
\DeclareOption{displayweek}{\setboolean{displayweek}{true}}
\DeclareOption{idw}{\setboolean{idw}{true}}
\DeclareOption{vdi}{\setboolean{vdi}{true}}
\DeclareOption{journal}{\setboolean{journal}{true}}
\ProcessOptions\relax

\ifthenelse{ \boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf} }%
{\typeout{Using displayweek option for sid class.}}
{} % else

\ifthenelse{\boolean{idw}}%
{\typeout{Using idw option for sid class}}
{} % else

\ifthenelse{\boolean{vdi}}%
{\typeout{Using vdi option for sid class}}
{} % else

\ifthenelse{\not\( \boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf} \OR \boolean{idw} \OR \boolean{vdi} \)}%
{\ClassError{sid}{Option not recognized}%
{Currently, package sid recognizes the following options:
displayweek (SID Display Week Technical Symposium),
idw (International Display Workshops), and
vdi (Vehicle Displays and Interfaces).}
}
{} % else


\LoadClass[twocolumn,10pt]{article}

\RequirePackage{geometry}
\RequirePackage{amsmath,amssymb,amsfonts}
\RequirePackage{xcolor}
\RequirePackage{graphicx}
\RequirePackage{enumitem}
\RequirePackage{balance}
\RequirePackage{titling}
\RequirePackage{titlesec}
\RequirePackage{xpatch}
\RequirePackage{caption}
\RequirePackage{hyperref}

\RequirePackage{fontspec}
\setmainfont{Times New Roman}
\setsansfont{Arial}
\setmonofont{Courier New}

\ifthenelse{ \boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf}}
{
\geometry{letterpaper, top=0.75in, left=0.75in, right=0.75in, bottom=1.00in,%
                columnsep=0.375in, verbose}

\pretitle{\vspace*{-0.4in}\begin{center}\normalfont\sffamily\fontsize{14pt}{15pt}\bfseries}
\posttitle{\end{center}}
\preauthor{\begin{center}\normalfont\sffamily\large\bfseries\itshape}
\postauthor{\end{center}\vspace{-0.4in}}
\newcommand{\affiliations}{\normalfont\sffamily\normalsize\bfseries}

\titleformat{\section}
  {\normalfont\sffamily\normalsize\bfseries}
  {\thesection.}{0.125in}{}
\titlespacing{\section}{0pt}{0pt}{-\parskip}

 \titleformat{\subsection}[runin]
 {\normalfont\sffamily\small\bfseries\itshape}
  {}{0pt}{}
\titlespacing{\subsection}{0pt}{0pt}{\wordsep}

 \titleformat{name=\subsubsection}[runin]
 {\normalfont\sffamily\small\bfseries\itshape}
  {(\thesubsubsection) }{3pt}{}
 \titlespacing{\subsubsection}
  {0pt}{0pt}{\wordsep}
 \renewcommand{\thesubsubsection}{\alph{subsubsection}}

\newcommand{\abstractfont}{\normalfont\small\bfseries\itshape}
\xpretocmd{\abstract}{\abstractfont}{}{}

\setlength\parskip{4pt plus 0.1pt minus 0.2pt}
\setlength\parindent{0pt}
}
{} % else

\ifthenelse{\boolean{idw}}
{
\geometry{a4paper, top=25mm, left=20mm, right=20mm, bottom=35mm,%
                columnsep=10mm, verbose}

\pretitle{\vspace*{-0.45in}\begin{center}\normalfont\sffamily\fontsize{16pt}{18pt}\bfseries}
\posttitle{\end{center}}
\preauthor{\begin{center}\normalfont\sffamily\fontsize{13pt}{15pt}\bfseries}
\postauthor{\end{center}\vspace{-0.45in}}
\newcommand{\affiliations}{\normalfont\sffamily\small\mdseries}
\titleformat{\section}
  {\normalfont\sffamily\small\bfseries}
  {\thesection}{0.125in}{}
\titlespacing{\section}{0pt}{0.5\baselineskip}{0pt}

 \titleformat{\subsection}
 {\normalfont\sffamily\small\bfseries}
  {\thesubsection}{0.125in}{}
\titlespacing{\subsection}{0pt}{0.5\baselineskip}{0pt}

\titleformat{\subsubsection}
 {\normalfont\sffamily\small\mdseries\itshape}
  {\thesubsubsection}{0.125in}{}
\titlespacing{\subsubsection}{0.15in}{0pt}{0pt}

\newcommand{\abstractfont}{\sffamily\small\mdseries\itshape}
\xpretocmd{\abstract}{\abstractfont}{}{}
\renewcommand{\abstractname}{ABSTRACT}

\setlength\parskip{0pt plus 0.1pt minus 0.2pt}
\setlength\parindent{0.15in}
} %
{} % else

\ifthenelse{ \boolean{vdi}}
{
\geometry{letterpaper, top=0.75in, left=0.75in, right=0.75in, bottom=1.00in,%
                columnsep=0.375in, verbose}
\pretitle{\vspace*{-0.4in}\begin{center}\normalfont\sffamily\fontsize{14pt}{15pt}\bfseries}
\posttitle{\end{center}}
\preauthor{\begin{center}\normalfont\sffamily\large\bfseries\itshape}
\postauthor{\end{center}\vspace{-0.4in}}
\newcommand{\affiliations}{\normalfont\sffamily\normalsize}

\titleformat{\section}
  {\normalfont\sffamily\normalsize\bfseries}
  {}{0.0in}{}
\titlespacing{\section}{0pt}{2\parskip}{-\parskip}

 \titleformat{\subsection}[runin]
 {\normalfont\rmfamily\normalsize\itshape}
  {}{0pt}{}
\titlespacing{\subsection}{0pt}{0pt}{\wordsep}
\newcommand{\abstractfont}{\normalfont\rmfamily\normalsize\itshape}
\renewenvironment{abstract}{{\normalfont\sffamily\normalsize\bfseries Abstract:}%
                             \abstractfont}{}
\newenvironment{keywords}{{\vspace{\parskip}%
                            \normalfont\sffamily\normalsize\bfseries Keywords:}}{}
\setlength\parskip{4pt plus 0.1pt minus 0.2pt}
\setlength\parindent{0pt}
}%
{} % else

\ifthenelse{\boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf}}
{
\newenvironment{keywords}{\section*{Author Keywords}}
}
{} % else

\ifthenelse{\boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf} \OR \boolean{idw}}
{
\captionsetup{font={sf,small,md}, labelfont=bf, labelsep=period}
}
{} % else

\ifthenelse{\boolean{vdi}}
{
\captionsetup{font={sf,md}, labelfont=bf, labelsep=period}
}
{} % else


 \ifthenelse{\boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf} \OR \boolean{vdi} }
 {
\newenvironment{numbered}{\begin{enumerate}[align=left, labelwidth=0.15in,%
                          labelsep=0.15in, leftmargin=0.3in]}%
     {\end{enumerate}}
}
{} % else

\ifthenelse{\boolean{idw}  }
{
\newenvironment{numbered}{\begin{enumerate}[label=(\arabic*), align=left,%
                          labelwidth=0.15in labelsep=1em, leftmargin=0.3in,%
                          itemsep=0pt, parsep=0pt]}%
     {\end{enumerate}}
}
{} %else

\ifthenelse{\boolean{displayweek} \OR \boolean{symposium} \OR \boolean{conf} \OR \boolean{idw} }
{
\newenvironment{bulletize}{\begin{enumerate}[label=$\bullet$, align=left,%
                           labelwidth=0.15in, labelsep=0.05in, leftmargin=0.4in]}%
     {\end{enumerate}}
}
{} %else

\ifthenelse{ \boolean{vdi}  }
{
\newenvironment{bulletize}{\begin{enumerate}[label=$\bullet$, align=left,%
                          labelwidth=0.15in, labelsep=0.15in, leftmargin=0.3in]}%
     {\end{enumerate}}
}
{} %else


\newlength{\graphicswidth}
\setlength{\graphicswidth}{0.450\textwidth}

\hypersetup{colorlinks=true, urlcolor=blue, citecolor=black, linkcolor=black}
\xpretocmd{\bibliography}{\begingroup\raggedright}{}{}
\xapptocmd{\bibliography}{\endgroup}{}{}
\endinput
%%
%% End of file `sid.cls'.
